#include "userprocess.h"
#include <stdio.h>
#include <math.h>
#include "message.h"
#include "sn_debug.h"

User_Process::User_Process(int in_num_processes)
{
	num_processes = in_num_processes;
}

// ----------------------------------------------------------------------------

void User_Process::Set_Start_State()
{
	u = process_id;
	send_plus.uid = u;
	send_plus.flag = out;
	send_plus.hop_count = 1;
	send_minus.uid = u;
	send_minus.flag = out;
	send_minus.hop_count = 1;
	status = unknown;
	phase = 0;
}

// ----------------------------------------------------------------------------

void User_Process::Generate_Messages()
{
	map<Message *,int> outgoing_messages;

	if (send_plus.uid != NULL_MESSAGE)
	{
		Message* outgoing_message_plus = new Message;
		outgoing_message_plus->uid = send_plus.uid;
		outgoing_message_plus->flag = send_plus.flag;
		outgoing_message_plus->hop_count = send_plus.hop_count;
		pair<Message *,int> msg_to_pair_plus(outgoing_message_plus, ((u % num_processes) + 1));
		outgoing_messages.insert(msg_to_pair_plus);
	}

	if (send_minus.uid != NULL_MESSAGE)
	{
		Message* outgoing_message_minus = new Message;
		outgoing_message_minus->uid = send_minus.uid;
		outgoing_message_minus->flag = send_minus.flag;
		outgoing_message_minus->hop_count = send_minus.hop_count;

		pair<Message *,int> msg_to_pair_minus(outgoing_message_minus, (((u + num_processes - 2) % num_processes) + 1));
		outgoing_messages.insert(msg_to_pair_minus);
	}

	// --------------------------------
	// Convert Messages to SN_Messages
	map<SN_Message *,int> outgoing_sn_messages;

	map<Message *,int>::iterator a_message;
	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		SN_Message* sn_message_ptr = reinterpret_cast<SN_Message *> (a_message->first);
		outgoing_sn_messages.insert(make_pair(sn_message_ptr,a_message->second));
	}
	// --------------------------------

	Send(&outgoing_sn_messages);

	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
		delete (a_message->first);
}

// ----------------------------------------------------------------------------

void User_Process::Transition(map<SN_Message *,int> inbound_sn_msgs)
{
	// -----------------------------------------------------------
	// First convert all the SN_Messages to our Messages
	map<Message *,int> inbound_msgs;
	map<SN_Message *,int>::iterator an_sn_msg;
	
	for(an_sn_msg = inbound_sn_msgs.begin();
		an_sn_msg != inbound_sn_msgs.end(); an_sn_msg++)
	{
		Message *a_msg = reinterpret_cast<Message *>(an_sn_msg->first);
		inbound_msgs.insert(make_pair(a_msg,an_sn_msg->second));
	}
	// -----------------------------------------------------------

	int v_minus;
	Flag out_minus;
	int h_minus;
	int v_plus;
	Flag out_plus;
	int h_plus;

	send_plus.uid = NULL_MESSAGE;
	send_minus.uid = NULL_MESSAGE;

	map<Message *,int>::iterator a_message;

	for (a_message = inbound_msgs.begin();a_message != inbound_msgs.end(); a_message++)
	{
		Message incoming_message = *(a_message->first);
		int from_uid = a_message->second;

		DEBUG_2("Process %d: v=%d, o=%d, h=%d, f=%d\n", u, incoming_message.uid, incoming_message.flag, 
			incoming_message.hop_count, from_uid);
		if (from_uid == ((u % num_processes) + 1))
		{
			v_plus = incoming_message.uid;
			out_plus = incoming_message.flag;
			h_plus = incoming_message.hop_count;
		}
		else if (from_uid == (((u + num_processes - 2) % num_processes) + 1))
		{
			v_minus = incoming_message.uid;
			out_minus = incoming_message.flag;
			h_minus = incoming_message.hop_count;
		}
		else
			DEBUG("ERROR: received message from invalid source on ring: %d\n", from_uid);
	}

	DEBUG_1("Process %d: received %d messages\n", u, inbound_msgs.size());

	if (out_minus == out)
	{
		if ((v_minus > u) && (h_minus > 1))
		{
			send_plus.uid = v_minus;
			send_plus.flag = out;
			send_plus.hop_count = h_minus - 1;
		}
		else if ((v_minus > u) && (h_minus == 1))
		{
			send_minus.uid = v_minus;
			send_minus.flag = in;
			send_minus.hop_count = 1;
		}
		else if (v_minus == u)
		{
			status = leader;
			DEBUG("Process %d: DECLARED ITSELF THE LEADER\n", u);
		}
	}
	if (out_plus == out)
	{
		if ((v_plus > u) && (h_plus > 1))
		{
			send_minus.uid = v_plus;
			send_minus.flag = out;
			send_minus.hop_count = h_plus - 1;
		}
		else if ((v_plus > u) && (h_plus == 1))
		{
			send_plus.uid = v_plus;
			send_plus.flag = in;
			send_plus.hop_count = 1;
		}
		else if (v_plus == u)
		{
			status = leader;
			DEBUG("Process %d: DECLARED ITSELF THE LEADER\n", u);
		}
	}
	if ((out_minus == in) && (h_minus == 1) && (v_minus != u))
	{
		send_plus.uid = v_minus;
		send_plus.flag = in;
		send_plus.hop_count = 1;
	}
	if ((out_plus == in) && (h_plus == 1) && (v_plus != u))
	{
		send_minus.uid = v_plus;
		send_minus.flag = in;
		send_minus.hop_count = 1;
	}
	if ((v_minus == u) && (out_minus == in) && (h_minus == 1) &&
		(v_plus == u) && (out_plus == in) && (h_plus == 1))
	{
		phase++;
		send_plus.uid = u;
		send_plus.flag = out;
		send_plus.hop_count = (int) pow(2, phase);
		send_minus.uid = u;
		send_minus.flag = out;
		send_minus.hop_count = (int) pow(2, phase);
		DEBUG_1("Process %d: moving on to phase %d\n", u, phase);
	}
}
